define(['angular', 'app', 'moment'], function (angular, app) {
	'use strict';
	app.controller('AssessmentBuilderListViewController', function ($scope, $state, globalDelayTracker, focusService, previousState, assessmentService) {
		
		var stopWatch = $scope.$watch('globalDelayTracker.active()', function(newValue, oldValue) {
			focusService.focusMain();
			previousState.isFirstAppRoute = false;
			stopWatch();
		});

		$scope.checkboxModel = {
			active: true,
			draft: true,
			inactive: false
		};
		$scope.headers = [
			{label: "Name", keys: "uniqueTitle"}, 
			{label: "Last Modified", keys: "lastModified"}, 
			{label: "Version", keys: "version"}, 
			{label: "Status", keys: "status"}
		]; 
		$scope.noFilterSelected = false;
		$scope.ordering = ['uniqueTitle', '-version']; 

		$scope.filter = function() {
			$scope.assessments = [];
			if (!$scope.checkboxModel.active && !$scope.checkboxModel.draft && !$scope.checkboxModel.inactive) {
				$scope.noFilterSelected = true;
			} else {
				$scope.noFilterSelected = false;
				$scope.allAssessments.forEach(function(assessment) {
					if (($scope.checkboxModel.active && assessment.status=='Active') || 
							($scope.checkboxModel.draft && assessment.status=='Draft') || 
							($scope.checkboxModel.inactive && assessment.status=='Inactive')) {
						$scope.assessments.push(assessment);
					}
				}); 
			}
		}; 

		$scope.globalDelayTracker = globalDelayTracker;
		$scope.globalDelayTracker.add('getAssessments');
		assessmentService.getAssessments().then(function(response) {
			$scope.allAssessments = response.data.assessment;
			$scope.filter(); 
			$scope.globalDelayTracker.remove('getAssessments'); 
		}); 

		$scope.openAssessment = function(assessment) {
			$state.go("^.edit", {assessment: assessment.item, id: assessment.item.id});
		}

		$scope.reset = function() {
			$scope.checkboxModel.active = true;
			$scope.checkboxModel.draft = true;
			$scope.checkboxModel.inactive = false; 
		};
	});
});